// Plik: Array.h
// Definicja klasy Array z przeciążonymi operatorami
#ifndef ARRAY_H
#define ARRAY_H

#include <iostream>

class Array
{
   friend std::ostream &operator<<( std::ostream &, const Array & );
   friend std::istream &operator>>( std::istream &, Array & );   

public:
   explicit Array( int = 10 ); // Konstruktor domyślny 
   Array( const Array & ); // Konstruktor kopiujący
   ~Array(); // Destruktor        
   size_t getSize() const; // Wartością zwrotną jest wielkość obiektu

   const Array &operator=( const Array & ); // Operator przypisania
   bool operator==( const Array & ) const; // Operator równości   

   // Operator nierówności, zwraca wartość przeciwną wobec zwracanej przez operator ==
   bool operator!=( const Array &right ) const  
   {
      return ! ( *this == right ); // Wywołuje Array::operator==
   } // Koniec funkcji operator!=()
   
   // Operator indeksu obiektów typu innego niż const zwracający modyfikowalną l-wartość
   int &operator[]( int );

   // Operator indeksu obiektów typu const zwracający r-wartość
   int operator[]( int ) const;
private:
   size_t size; // Wielkość tablicy opartej na wskaźnikach
   int *ptr; // Wskaźnik prowadzący do pierwszego elementu tablicy opartej na wskaźnikach
}; // Koniec klasy Array

#endif
