// Plik : Date.cpp
// Definicje elementów składowych klasy Date i funkcji zaprzyjaźnionych
#include <iostream>
#include <string>
#include "Date.h"
using namespace std;

// Inicjalizacja elementu statycznego, to jest tylko jedna kopia o zasięgu klasy
const array< unsigned int, 13 > Date::days = 
   { 0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

// Konstruktor klasy Date
Date::Date( int day, int month, int year ) 
{ 
   setDate( day, month, year ); 
} // Koniec konstruktora klasy Date

// Zdefiniowanie miesiąca, dnia i roku
void Date::setDate( int dd, int mm, int yy )
{
   if ( mm >= 1 && mm <= 12 )
      month = mm;
   else
      throw invalid_argument( "Miesiąc musi być wartością z przedziału 1-12." );

   if ( yy >= 1900 && yy <= 2100 )
      year = yy;
   else
      throw invalid_argument( "Rok musi być wartością >= 1900 i <= 2100." );

   // Sprawdzenie pod kątem roku przestępnego
   if ( ( month == 2 && leapYear( year ) && dd >= 1 && dd <= 29 ) ||
        ( dd >= 1 && dd <= days[ month ] ) )
      day = dd;
   else  
      throw invalid_argument( 
         "Podany dzień wykracza poza zakres wartości dla bieżącego miesiąca i roku." );
} // Koniec funkcji setDate()

// Przeciążony operator inkrementacji typu prefiks       
Date &Date::operator++()  
{
   helpIncrement(); // Inkrementacja daty
   return *this; // Zwrot odwołania do utworzenia l-wartości
} // Koniec funkcji operator++()

// Przeciążony operator inkrementacji typu postfiks; zwróć uwagę na użycie
// parametru sztucznej wartości, który nie ma nazwy
Date Date::operator++( int ) 
{
   Date temp = *this; // Przechowuje bieżący stan obiektu
   helpIncrement();  

   // Zwrot nieinkrementowanego zapisanego obiektu tymczasowego 
   return temp; // Wartość zwrotna, nie odwołanie
} // Koniec funkcji operator++()

// Dodanie określonej liczby dni do daty
Date &Date::operator+=( unsigned int additionalDays )
{
   for ( int i = 0; i < additionalDays; ++i )  
      helpIncrement();   
      
   return *this; // Pozwala na użycie polecenia kaskadowego
} // Koniec funkcji operator+=()

// W przypadku roku przestępnego wartością zwrotną jest true, w przeciwnym razie funkcja zwraca false
bool Date::leapYear( int testYear )
{
   if ( testYear % 400 == 0 || 
      ( testYear % 100 != 0 && testYear % 4 == 0 ) )
      return true; // Mamy rok przestępny
   else
      return false; // Nie mamy roku przestępnego
} // Koniec funkcji leapYear()

// Ustalenie, czy dany dzień jest ostatnim dniem miesiąca
bool Date::endOfMonth( int testDay ) const
{
   if ( month == 2 && leapYear( year ) )
      return testDay == 29; // Ostatni dzień lutego w roku przestępnym
   else
      return testDay == days[ month ];
} // Koniec funkcji endOfMonth()

// Funkcja pomagająca w inkrementacji daty
void Date::helpIncrement()
{
   // To nie jest ostatni dzień miesiąca
   if ( !endOfMonth( day ) )
      ++day; // Inkrementacja dnia
   else 
      if ( month < 12 ) // To jest ostatni dzień miesiąca, a liczba wskazująca miesiąc ma wartość mniejszą niż 12
      {
         ++month; // Inkrementacja liczby określającej miesiąc
         day = 1; // Pierwszy dzień nowego miesiąca
      } // Koniec konstrukcji if
      else // Ostatni dzień roku
      {
         ++year; // Inkrementacja liczby określającej rok
         month = 1; // Pierwszy miesiąc nowego roku
         day = 1; // Pierwszy dzień nowego miesiąca
      } // Koniec bloku else
} // Koniec funkcji helpIncrement()

// Przeciążony operator przekazywania danych do strumienia
ostream &operator<<( ostream &output, const Date &d )
{
   static string monthName[ 13 ] = { "", "styczeń", "luty",
      "marzec", "kwiecień", "maj", "czerwiec", "lipiec", "sierpień",
      "wrzesień", "październik", "listopad", "grudzień" };
   output << d.day << ' ' << monthName[ d.month ] << ' ' << d.year;
   return output; // Pozwala na użycie polecenia kaskadowego
} // Koniec funkcji operator<<()
