// Plik: fig17_06.cpp 
// Konstruktor z argumentami domyślnymi
#include <iostream>
#include <stdexcept>
#include "Time.h" // Dołączenie definicji klasy Time z pliku nagłówkowego Time.h
using namespace std;

int main()
{
   Time t1; // Wszystkie argumenty mają wartości domyślne
   Time t2( 2 ); // Została podana godzina, wartości minuty i sekundy są domyślne
   Time t3( 21, 34 ); // Została podana godzina i minuta, wartość sekundy jest domyślna
   Time t4( 12, 25, 42 ); // Zostały podane godzina, minuta i sekunda

   cout << "Sposób wywołania konstruktora:\n\nt1: Wszystkie argumenty mają wartości domyślne.\n  ";
   t1.printUniversal(); // 00:00:00
   cout << "\n  ";
   t1.printStandard(); // 12:00:00 AM

   cout << "\n\nt2: Została podana godzina, wartości minuty i sekundy są domyślne.\n  ";
   t2.printUniversal(); // 02:00:00
   cout << "\n  ";
   t2.printStandard(); // 2:00:00 AM

   cout << "\n\nt3: Została podana godzina i minuta, wartość sekundy jest domyślna.\n  ";
   t3.printUniversal(); // 21:34:00
   cout << "\n  ";
   t3.printStandard(); // 9:34:00 PM

   cout << "\n\nt4: Zostały podane godzina, minuta i sekunda.\n  ";
   t4.printUniversal(); // 12:25:42
   cout << "\n  ";
   t4.printStandard(); // 12:25:42 PM

   // Próba inicjalizacji obiektu t5 z nieprawidłowymi wartościami
   try
   {
      Time t5( 27, 74, 99 ); // Wszystkie właściwości są nieprawidłowe
   } // Koniec bloku try
   catch ( invalid_argument &e )
   {
      cerr << "\n\nWyjątek podczas inicjalizacji obiektu t5: " << e.what() << endl;
   } // Koniec bloku catch
} // Koniec funkcji main()
