// Plik: Employee.cpp
// Definicje funkcji składowych klasy Employee
#include <iostream>
#include "Employee.h" // Definicja klasy Employee
#include "Date.h" // Definicja klasy Date
using namespace std;

// Konstruktor używa listy inicjalizacyjnej do przekazania odpowiednich 
// wartości konstruktorom obiektów elementów składowych
Employee::Employee( const string &first, const string &last,
   const Date &dateOfBirth, const Date &dateOfHire )
   : firstName( first ), // Inicjalizacja wartości firstName
     lastName( last ), // Inicjalizacja wartości lastName
     birthDate( dateOfBirth ), // Inicjalizacja wartości birthDate
     hireDate( dateOfHire ) // Inicjalizacja wartości hireDate
{
   // Wyświetlenie obiektu Employee, aby pokazać, kiedy nastąpiło wywołanie konstruktora
   cout << "Konstruktor obiektu Employee reprezentującego osobę: " 
      << firstName << ' ' << lastName << endl;
} // Koniec konstruktora klasy Employee

// Wyświetlenie obiektu Employee
void Employee::print() const
{
   cout << lastName << ", " << firstName << "  Data zatrudnienia: ";
   hireDate.print();
   cout << "  Data urodzenia: ";
   birthDate.print();
   cout << endl;
} // Koniec funkcji print()

// Wyświetlenie obiektu Employee, aby pokazać, kiedy nastąpiło wywołanie destruktora
Employee::~Employee()
{ 
   cout << "Destruktor obiektu Employee reprezentującego osobę: " 
      << lastName << ", " << firstName << endl;
} // Koniec destruktora ~Employee
