// Plik: fig06_19.c
// Wyszukiwanie binarne elementu tablicy posortowanej
#include <stdio.h>
#define SIZE 15

// Prototypy funkcji
size_t binarySearch(const int b[], int searchKey, size_t low, size_t high);
void printHeader(void);
void printRow(const int b[], size_t low, size_t mid, size_t high);

// Funkcja main() rozpoczyna wykonywanie programu
int main(void)
{
   int a[SIZE]; // Utworzenie tablicy a

   // Utworzenie danych
   for (size_t i = 0; i < SIZE; ++i) {
      a[i] = 2 * i;
   } 

   printf("%s", "Podaj liczbę z przedziału od 0 do 28: ");
   int key; // Wartość do wyszukania w tablicy a
   scanf("%d", &key);

   printHeader();

   // Wyszukiwanie klucza w tablicy a
   size_t result = binarySearch(a, key, 0, SIZE - 1);

   // Wyświetlenie wyników
   if (result != -1) {
      printf("\nElement %d znaleziono w położeniu o indeksie %d\n", key, result);
   } 
   else {
      printf("\nNie znaleziono elementu %d\n", key);
   } 
} 

// Funkcja przeprowadzająca wyszukiwanie binarne w tablicy
size_t binarySearch(const int b[], int searchKey, size_t low, size_t high)
{
   // Iteracja dopóty, dopóki indeks low jest większy niż indeks high
   while (low <= high) {

      // Ustalenie elementu środkowego przeszukiwanego fragmentu tablicy
      size_t middle = (low + high) / 2;

      // Wyświetlenie fragmentu tablicy użytego w trakcie danej iteracji
      printRow(b, low, middle, high);

      // Jeżeli wartość searchKey została dopasowana do elementu środkowego, należy go zwrócić
      if (searchKey == b[middle]) {
         return middle;
      }

      // Jeżeli wartość searchKey jest mniejsza niż element środkowy, należy zdefiniować nową wartość high
      else if (searchKey < b[middle]) { 
         high = middle - 1; // Przeszukiwanie pierwszej połowy tablicy
      }

      // Jeżeli wartość searchKey jest większa niż element środkowy, należy zdefiniować nową wartość low
      else { 
         low = middle + 1; // Przeszukiwanie drugiej połowy tablicy
      } 
   } // Koniec pętli while

   return -1; // Wartość searchKey nie została znaleziona
} 

// Wyświetlenie nagłówka danych wyjściowych
void printHeader(void)
{
   puts("\nIndeksy:");

   // Nagłówek kolumny danych wyjściowych
   for (unsigned int i = 0; i < SIZE; ++i) {
      printf("%3u ", i);
   } 

   puts(""); // Rozpoczęcie nowego wiersza danych wyjściowych

   // Wyświetlenie wiersza znaków -
   for (unsigned int i = 1; i <= 4 * SIZE; ++i) {
      printf("%s", "-");
   } 

   puts(""); // Rozpoczęcie nowego wiersza danych wyjściowych
} 

// Wyświetlenie wiersza danych wyjściowych zawierającego
// aktualnie przetwarzany fragment tablicy
void printRow(const int b[], size_t low, size_t mid, size_t high)
{
   // Iteracja przez całą tablicę
   for (size_t i = 0; i < SIZE; ++i) {

      // Wyświetlenie spacji w przypadku wyjścia poza bieżący fragment tablicy
      if (i < low || i > high) {
         printf("%s", "    ");
      }  
      else if (i == mid) { // Wyświetlenie elementu środkowego
         printf("%3d*", b[i]); // Oznaczenie wartości środkowej
      }  
      else { // Wyświetlenie pozostałych elementów przetwarzanego fragmentu tablicy
         printf("%3d ", b[i]);
      } 
   } 

   puts(""); // Rozpoczęcie nowego wiersza danych wyjściowych
}
