// Plik: figE_12.c
// Obliczenia liczb ciągu Fibonacciego wykonywane w oddzielnych wątkach
#include <stdio.h>
#include <threads.h>
#include <time.h>

#define NUMBER_OF_THREADS 2

int startFibonacci(void *nPtr);
unsigned long long int fibonacci(unsigned int n); 

typedef struct ThreadData {
   time_t startTime; // Godzina rozpoczęcia przetwarzania przez wątek
   time_t endTime; // Godzina zakończenia przetwarzania przez wątek
   unsigned int number; // Liczba Fibonacciego do obliczenia
} ThreadData; // Koniec struktury ThreadData

int main(void) 
{
   // Dane przekazywane wątkom, stosowane są wyznaczone metody inicjalizacyjne
   ThreadData data[NUMBER_OF_THREADS] = 
      { [0] = {.number = 50},   
        [1] = {.number = 49}};

   // Każdy wątek wymaga identyfikatora wątku typu thrd_t
   thrd_t threads[NUMBER_OF_THREADS];    

   puts("Wywołania fibonacci(50) i fibonacci(49) w oddzielnych wątkach");

   // Utworzenie i uruchomienie wątków
   for (size_t i = 0; i < NUMBER_OF_THREADS; ++i) {
      printf("Uruchamianie wątku przeznaczonego do obliczenia fibonacci(%d)\n", 
         data[i].number);

      // Utworzenie wątku i sprawdzenie, czy ta operacja zakończyła się powodzeniem
      if (thrd_create(&threads[i], startFibonacci, &data[i]) !=
         thrd_success) {

         puts("Nie udało się utworzyć wątku.");
      } 
   } 

   // Oczekiwanie na zakończenie obliczeń
   for (size_t i = 0; i < NUMBER_OF_THREADS; ++i)
      thrd_join(threads[i], NULL);

   // Określenie czasu rozpoczęcia działania przez pierwszy wątek
   time_t startTime = (data[0].startTime < data[1].startTime) ? 
      data[0].startTime : data[1].startTime;

   // Określenie czasu rozpoczęcia działania przez ostatni wątek
   time_t endTime = (data[0].endTime > data[1].endTime) ? 
      data[0].endTime : data[1].endTime;

   // Wyświetlenie całkowitego czasu obliczeń
   printf("Całkowity czas obliczeń = %f minut(y)\n", 
      difftime(endTime, startTime) / 60.0);
} 

// Funkcja wywoływana przez wątek rozpoczynający rekurencyjne obliczanie liczby ciągu Fibonacciego
int startFibonacci(void *ptr)
{
   // Rzutowanie ptr na ThreadData * w celu uzyskania dostępu do argumentów
   ThreadData *dataPtr = (ThreadData *) ptr;

   dataPtr->startTime = time(NULL); // Godzina przed rozpoczęciem obliczeń
 
   printf("Obliczenia dla wywołania fibonacci(%d)\n", dataPtr->number);
   printf("fibonacci(%d) = %lld\n", 
      dataPtr->number, fibonacci(dataPtr->number));

   dataPtr->endTime = time(NULL); // Godzina po zakończeniu obliczeń
 
   printf("Czas obliczeń = %f minut(y)\n\n", 
      difftime(dataPtr->endTime, dataPtr->startTime) / 60.0);
   return thrd_success; 
} 

// Rekurencyjne obliczanie liczb ciągu Fibonacciego
unsigned long long int fibonacci(unsigned int n)      
{                                                         
   // Przypadek bazowy                                           
   if (0 == n || 1 == n) {                               
      return n;                                            
   }                                            
   else { // Krok rekurencyjny                            
      return fibonacci(n - 1) + fibonacci(n - 2);        
   }                                         
} 
