// Plik: fig22_06.cpp
// Przykład użycia funkcji set_new_handler()
#include <iostream>
#include <new> // Ten nagłówek zawiera prototyp funkcji set_new_handler()
#include <cstdlib> // Ten nagłówek zawiera prototyp funkcji abort()
using namespace std;

// Obsługa niepowodzenia operacji alokowania pamięci
void customNewHandler()
{
   cerr << "Wywołana została funkcja customNewHandler().";
   abort();
} // Koniec funkcji customNewHandler()

// Użycie funkcji set_new_handler() do obsługi nieudanej alokacji pamięci
int main()
{
   double *ptr[ 50 ];

   // Określenie, że funkcja customNewHandler() powinna zostać wywołana
   // w przypadku zakończonej niepowodzeniem operacji alokowania pamięci
   set_new_handler( customNewHandler );

   // Każde wywołanie ptr[i] alokuje ogromną ilość pamięci, funkcja customNewHandler() zostanie
   // wywołana w przypadku zakończonej niepowodzeniem operacji alokowania pamięci
   for ( size_t i = 0; i < 50; ++i )
   {
      ptr[ i ] = new double[ 50000000 ]; // To polecenie może zgłosić wyjątek
      cout << "ptr[" << i << "] prowadzi do 50 000 000 nowych wartości typu double\n";
   } // Koniec pętli for
}  // Koniec funkcji main()
