// Plik: fig20_19.cpp
// Przykład wykorzystania rzutowania w dół i RTTI
// UWAGA: być może trzeba będzie włączyć obsługę RTTI
// w kompilatorze przed kompilacją tej aplikacji
#include <iostream>
#include <iomanip>
#include <vector>
#include <typeinfo>
#include "Employee.h"
#include "SalariedEmployee.h" 
#include "CommissionEmployee.h"  
#include "BasePlusCommissionEmployee.h" 
using namespace std;

int main()
{
   // Formatowanie liczb zmiennoprzecinkowych w danych wyjściowych
   cout << fixed << setprecision( 2 ); 
   
   // Utworzenie kontenera typu vector trzech wskaźników typu klasy bazowej
   vector < Employee * > employees( 3 );

   // Inicjalizacja kontenera typu vector z obiektami reprezentującymi różne grupy pracowników
   employees[ 0 ] = new SalariedEmployee(
      "Jan", "Sawicki", "111-11-1111", 800 );
   employees[ 1 ] = new CommissionEmployee(
      "Sara", "Janowska", "333-33-3333", 10000, .06 );
   employees[ 2 ] = new BasePlusCommissionEmployee(
      "Bartek", "Lewicki", "444-44-4444", 5000, .04, 300 );

   // Polimorficzne przetworzenie poszczególnych elementów kontenera employees
   for ( Employee *employeePtr : employees ) 
   {
      employeePtr->print(); // Wyświetlenie informacji o pracowniku
      cout << endl;

      // Próba rzutowania wskaźnika w dół     
      BasePlusCommissionEmployee *derivedPtr =
         dynamic_cast < BasePlusCommissionEmployee * >( employeePtr );

      // Ustalenie, czy element prowadzi do typu BasePlusCommissionEmployee
      if ( derivedPtr != nullptr ) // Prawda w przypadku relacji typu "jest"
      {
         double oldBaseSalary = derivedPtr->getBaseSalary();
         cout << "Poprzednie wynagrodzenie zasadnicze: " << oldBaseSalary << endl;
         derivedPtr->setBaseSalary( 1.10 * oldBaseSalary );
         cout << "Nowe wynagrodzenie zasadnicze po podwyżce 10% wynosi:" 
            << derivedPtr->getBaseSalary()  << endl;
      } // Koniec konstrukcji if
      
      cout << "Wynagrodzenie: " << employeePtr->earnings() << "\n\n";
   } // Koniec konstrukcji for
 
   // Zwolnienie obiektów wskazywanych przez elementy kontenera
   for ( const Employee *employeePtr : employees ) 
   {
      // Wyświetlenie nazwy klasy
      cout << "Usunięcie obiektu typu "
         << typeid( *employeePtr ).name() << endl;

      delete employeePtr;
   } // Koniec konstrukcji for
} // Koniec funkcji main()
