// Plik: SalariedEmployee.h
// Klasa SalariedEmployee będąca klasą pochodną Employee
#ifndef SALARIED_H
#define SALARIED_H

#include <string> // Standardowa klasa string w C++
#include "Employee.h" // Definicja klasy Employee

class SalariedEmployee : public Employee
{
public:
   SalariedEmployee( const std::string &, const std::string &, 
      const std::string &, double = 0.0 );
   virtual ~SalariedEmployee() { } // Destruktor wirtualny

   void setWeeklySalary( double ); // Zdefiniowanie wynagrodzenia tygodniowego
   double getWeeklySalary() const; // Pobranie wynagrodzenia tygodniowego

   // Słowo kluczowe virtual oznacza, że funkcja powinna być nadpisana
   virtual double earnings() const override; // Obliczenie wynagrodzenia
   virtual void print() const override; // Wyświetlenie zawartości obiektu         
private:
   double weeklySalary; // Wynagrodzenie tygodniowe
}; // Koniec klasy SalariedEmployee

#endif // SALARIED_H
