// Plik: BasePlusCommissionEmployee.cpp
// Definicje funkcji składowych klasy BasePlusCommissionEmployee
#include <iostream>
#include <stdexcept>
#include "BasePlusCommissionEmployee.h"
using namespace std;

// Konstruktor 
BasePlusCommissionEmployee::BasePlusCommissionEmployee( 
   const string &first, const string &last, const string &ssn, 
   double sales, double rate, double salary )
   : CommissionEmployee( first, last, ssn, sales, rate)   
{
   setBaseSalary( salary ); // Weryfikacja i przechowywanie wynagrodzenia zasadniczego
} // Koniec konstruktora klasy BasePlusCommissionEmployee

// Zdefiniowanie wynagrodzenia zasadniczego
void BasePlusCommissionEmployee::setBaseSalary( double salary )
{ 
   if ( salary >= 0.0 )                                        
      baseSalary = salary;                                     
   else                                                        
      throw invalid_argument( "Wynagrodzenie musi być wartością >= 0.0" );       
} // Koniec funkcji setBaseSalary()

// Pobranie wynagrodzenia zasadniczego
double BasePlusCommissionEmployee::getBaseSalary() const
{ 
    return baseSalary; 
} // Koniec funkcji getBaseSalary()

// Obliczenie wynagrodzenia
// Nadpisanie funkcji wirtualnej earnings() klasy CommissionEmployee
double BasePlusCommissionEmployee::earnings() const
{ 
   return getBaseSalary() + CommissionEmployee::earnings();
} // Koniec funkcji earnings()

// Wyświetlenie informacji przechowywanych w obiekcie BasePlusCommissionEmployee
void BasePlusCommissionEmployee::print() const
{
   cout << "Pracownik otrzymujący wynagrodzenie zasadnicze i prowizję ";
   CommissionEmployee::print(); // Ponowne użycie kodu
   cout << "; Wynagrodzenie zasadnicze: " << getBaseSalary();
} // Koniec funkcji print()
