// Plik: BasePlusCommissionEmployee.cpp
// Definicje funkcji składowych klasy BasePlusCommissionEmployee
#include <iostream>
#include <stdexcept>
#include "BasePlusCommissionEmployee.h"
using namespace std;

// Konstruktor
BasePlusCommissionEmployee::BasePlusCommissionEmployee( 
   const string &first, const string &last, const string &ssn, 
   double sales, double rate, double salary )
{
   firstName = first; // Ta wartość powinna zostać zweryfikowana
   lastName = last; // Ta wartość powinna zostać zweryfikowana
   socialSecurityNumber = ssn; // Ta wartość powinna zostać zweryfikowana
   setGrossSales( sales ); // Weryfikacja i przypisanie wielkości sprzedaży
   setCommissionRate( rate ); // Weryfikacja i przypisanie wysokości prowizji
   setBaseSalary( salary ); // Weryfikacja i przypisanie wysokości wynagrodzenia zasadniczego
} // Koniec konstruktora klasy BasePlusCommissionEmployee

// Zdefiniowanie imienia
void BasePlusCommissionEmployee::setFirstName( const string &first )
{
   firstName = first; // Ta wartość powinna zostać zweryfikowana
} // Koniec funkcji setFirstName()

// Pobranie imienia
string BasePlusCommissionEmployee::getFirstName() const
{
   return firstName;
} // Koniec funkcji getFirstName()

// Zdefiniowanie nazwiska
void BasePlusCommissionEmployee::setLastName( const string &last )
{
   lastName = last; // Ta wartość powinna zostać zweryfikowana
} // Koniec funkcji setLastName()

// Pobranie nazwiska
string BasePlusCommissionEmployee::getLastName() const
{
   return lastName;
} // Koniec funkcji getLastName()

// Zdefiniowanie numeru ubezpieczenia społecznego
void BasePlusCommissionEmployee::setSocialSecurityNumber( 
   const string &ssn )
{
   socialSecurityNumber = ssn; // Ta wartość powinna zostać zweryfikowana
} // Koniec funkcji setSocialSecurityNumber()

// Pobranie numeru ubezpieczenia społecznego
string BasePlusCommissionEmployee::getSocialSecurityNumber() const
{
   return socialSecurityNumber;
} // Koniec funkcji getSocialSecurityNumber()

// Zdefiniowanie wielkości sprzedaży
void BasePlusCommissionEmployee::setGrossSales( double sales )
{
   if ( sales >= 0.0 )
      grossSales = sales;
   else
      throw invalid_argument( "Wielkość sprzedaży musi być wartością >= 0.0" );
} // Koniec funkcji setGrossSales()

// Pobranie wielkości sprzedaży
double BasePlusCommissionEmployee::getGrossSales() const
{
   return grossSales;
} // Koniec funkcji getGrossSales()

// Zdefiniowanie procentowej wysokości prowizji
void BasePlusCommissionEmployee::setCommissionRate( double rate )
{
   if ( rate > 0.0 && rate < 1.0 )
      commissionRate = rate;
   else
      throw invalid_argument( "Wysokość prowizji musi być wartością > 0.0 i < 1.0"  );
} // Koniec funkcji setCommissionRate()

// Pobranie procentowej wysokości prowizji
double BasePlusCommissionEmployee::getCommissionRate() const
{
   return commissionRate;
} // Koniec funkcji getCommissionRate()

// Zdefiniowanie wynagrodzenia zasadniczego
void BasePlusCommissionEmployee::setBaseSalary( double salary )
{
   if ( salary >= 0.0 )
      baseSalary = salary; 
   else 
      throw invalid_argument( "Wynagrodzenie musi być wartością >= 0.0" );
} // Koniec funkcji setBaseSalary()

// Pobranie wynagrodzenia zasadniczego
double BasePlusCommissionEmployee::getBaseSalary() const
{
   return baseSalary;
} // Koniec funkcji getBaseSalary()

// Obliczenie wynagrodzenia
double BasePlusCommissionEmployee::earnings() const
{
   return baseSalary + ( commissionRate * grossSales );
} // Koniec funkcji earnings()

// Wyświetlenie zawartości obiektu BasePlusCommissionEmployee
void BasePlusCommissionEmployee::print() const
{
   cout << "Pracownik otrzymujący wynagrodzenie zasadnicze i prowizję " << firstName << ' ' 
      << lastName << "\nNumer ubezpieczenia społecznego: " << socialSecurityNumber 
      << "\nWielkość sprzedaży: " << grossSales 
      << "\nWysokość prowizji: " << commissionRate 
      << "\nWynagrodzenie zasadnicze: " << baseSalary;
} // Koniec funkcji print()
