// Plik: Time.h
// Kaskadowe wywołania funkcji składowych

// Definicja klasy Time
// Funkcje składowe są zdefiniowane w pliku Time.cpp
#ifndef TIME_H
#define TIME_H

class Time 
{
public:
   explicit Time( int = 0, int = 0, int = 0 ); // Konstruktor domyślny

   // Funkcje typu set (typ zwrotny Time & pozwala zastosować kaskadę)
   Time &setTime( int, int, int ); // Ustawienie godziny, minuty i sekundy
   Time &setHour( int ); // Ustawienie godziny
   Time &setMinute( int ); // Ustawienie minuty
   Time &setSecond( int ); // Ustawienie sekundy

   // Funkcje typu get (normalnie deklarowane jako const)
   unsigned int getHour() const; // Zwrot wartości reprezentującej godzinę
   unsigned int getMinute() const; // Zwrot wartości reprezentującej minutę
   unsigned int getSecond() const; // Zwrot wartości reprezentującej sekundę

   // Funkcje print (normalnie deklarowane jako const)
   void printUniversal() const; // Wyświetlenie godziny w formacie uniwersalnym
   void printStandard() const; // Wyświetlenie godziny w formacie standardowym
private:
   unsigned int hour; // 0 – 23 (zegar 24-godzinny)
   unsigned int minute; // 0 – 59
   unsigned int second; // 0 – 59
}; // Koniec klasy Time

#endif
