// Plik: Date.h 
// Definicja klasy Date; funkcje składowe są zdefiniowane w pliku Date.cpp
#ifndef DATE_H
#define DATE_H

class Date 
{
public:
   static const unsigned int monthsPerYear = 12; // Liczba miesięcy w roku
   explicit Date( int = 1, int = 1, int = 1900 ); // Konstruktor domyślny
   void print() const; // Wyświetlenie daty w formacie dzień/miesiąc/rok
   ~Date(); // Funkcja została zdefiniowana, aby potwierdzić kolejność usuwania obiektów
private:
   unsigned int month; // 1 – 12 (styczeń – grudzień)
   unsigned int day; // 1 – 31 w zależności od miesiąca
   unsigned int year; // Dowolny rok

   // Funkcja narzędziowa sprawdzająca poprawność dnia dla miesiąca i roku
   unsigned int checkDay( int ) const; 
}; // Koniec klasy Date

#endif
