// Plik: Time.cpp
// Definicje funkcji składowych klasy Time
#include <stdexcept>
#include "Time.h" // Dołączenie definicji klasy Time
using namespace std;

// Funkcja konstruktora inicjalizuje dane prywatne, wywołuje funkcję składową setTime() w celu
// przypisania wartości zmiennym; wartościami domyślnymi są 0 (spójrz na definicję klasy)
Time::Time( int hr, int min, int sec ) 
{
   setTime( hr, min, sec ); 
} // Koniec konstruktora klasy Time

// Przypisanie wartości dla godziny, minuty i sekundy
void Time::setTime( int h, int m, int s )
{
   // Weryfikacja wartości reprezentujących godzinę, minutę i sekundę
   if ( ( h >= 0 && h < 24 ) && ( m >= 0 && m < 60 ) && 
      ( s >= 0 && s < 60 ) ) 
   {
      hour = h;
      minute = m;
      second = s;
   } // Koniec konstrukcji if
   else
      throw invalid_argument(                            
         "Nieprawidłowa wartość godziny, minuty lub sekundy" );
} // Koniec funkcji setTime()

// Zwrot wartości reprezentującej godzinę
unsigned int Time::getHour() const
{ 
   return hour;
} // Koniec funkcji getHour()

// Kiepska praktyka programistyczna: zwrot odwołania do prywatnych danych składowych
unsigned int &Time::badSetHour( int hh )
{                                                                
   if ( hh >= 0 && hh < 24 )
      hour = hh;
   else
      throw invalid_argument( "Wartość godziny musi mieścić się w przedziale 0-23." );

   return hour; // Zwrot niebezpiecznego odwołania                   
} // Koniec funkcji badSetHour()    
