// Plik: fig17_03.cpp
// Program pozwalający przetestować klasę Time              
// UWAGA: Ten plik musi być skompilowany wraz z plikiem Time.cpp
#include <iostream>
#include <stdexcept> // Nagłówek niezbędny dla klasy wyjątku invalid_argument
#include "Time.h" // Dołączenie definicji klasy Time z pliku nagłówkowego Time.h
using namespace std;

int main()
{
   Time t; // Utworzenie obiektu t klasy Time

   // Wyświetlenie wartości początkowych obiektu t klasy Time
   cout << "Początkowa godzina w formacie uniwersalnym to ";
   t.printUniversal(); // 00:00:00
   cout << "\nPoczątkowa godzina w formacie standardowym to ";
   t.printStandard(); // 12:00:00 AM

   t.setTime( 13, 27, 6 ); // Zmiana godziny

   // Wyświetlenie nowych wartości obiektu t klasy Time
   cout << "\n\nGodzina w formacie uniwersalnym po wywołaniu funkcji setTime() to ";
   t.printUniversal(); // 13:27:06
   cout << "\nGodzina w formacie standardowym po wywołaniu funkcji setTime() to ";
   t.printStandard(); // 1:27:06 PM

   // Próba przypisania nieprawidłowych wartości komponentom godziny
   try
   {
      t.setTime( 99, 99, 99 ); // Wszystkie wartości są spoza dozwolonego przedziału
   } // Koniec bloku try
   catch ( invalid_argument &e )
   {
      cout << "Wyjątek: " << e.what() << endl;
   } // Koniec bloku catch

   // Wyświetlenie wartości obiektu t po podaniu nieprawidłowych wartości komponentów godziny
   cout << "\n\nPo próbie podania nieprawidłowych wartości godziny:"
      << "\nGodzina w formacie uniwersalnym to ";
   t.printUniversal(); // 13:27:06
   cout << "\nGodzina w formacie standardowym to ";
   t.printStandard(); // 1:27:06 PM
   cout << endl;
} // Koniec funkcji main()
