// Plik: Time.cpp
// Definicje funkcji składowych klasy Time
#include <iostream>
#include <iomanip>
#include <stdexcept> // Nagłówek niezbędny dla klasy wyjątku invalid_argument
#include "Time.h" // Dołączenie definicji klasy Time z pliku nagłówkowego Time.h

using namespace std;

// Konstruktor klasy Time inicjalizuje wszystkie dane składowe z wartością zero
Time::Time() 
   : hour( 0 ), minute( 0 ), second( 0 )
{ 
} // Koniec konstruktora klasy Time

// Ustawienie nowych wartości klasy Time z użyciem czasu uniwersalnego
void Time::setTime( int h, int m, int s )
{
   // Weryfikacja wartości reprezentujących godzinę, minutę i sekundę
   if ( ( h >= 0 && h < 24 ) && ( m >= 0 && m < 60 ) && 
      ( s >= 0 && s < 60 ) ) 
   {
      hour = h;
      minute = m;
      second = s;
   } // Koniec konstrukcji if
   else
      throw invalid_argument(   
           "Nieprawidłowa wartość godziny, minuty lub sekundy"); 
} // Koniec funkcji setTime()

// Wyświetlenie godziny w formacie czasu uniwersalnego (GG:MM:SS)
void Time::printUniversal() const
{
   cout << setfill( '0' ) << setw( 2 ) << hour << ":" 
      << setw( 2 ) << minute << ":" << setw( 2 ) << second;
} // Koniec funkcji printUniversal()

// Wyświetlenie godziny w formacie czasu uniwersalnego (GG:MM:SS AM lub PM)
void Time::printStandard() const
{
   cout << ( ( hour  == 0 || hour  == 12 ) ? 12 : hour  % 12 ) << ":" 
      << setfill ( '0' )  << setw( 2 ) << minute  << ":" << setw( 2 )
      << second  << ( hour  < 12 ? " AM" : " PM" );
} // Koniec funkcji printStandard()
