// Przykładowy program nr 1 z rozdziału 26 książki programowanie w języku C
// dla początkujących.
// Plik r26_1.c


/* Program generujący określoną liczbę losowych liczb całkowitych, alokujący
tablicę i napełniający ją liczbami od 1 do 500, a następnie przeglądający
za pomocą pętli te liczby i znajdujący najmniejszą, największą i średnią.
Na zakończenie program zwalnia zajmowaną pamięć. */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

main()
{
    system("chcp 65001");

    int i, aSize;

    int * randomNums;

    time_t t;

    double total = 0;
    int biggest, smallest;
    float average;

    srand(time(&t));

    printf("Ile liczb losowych chcesz zapisać w tablicy? ");
    scanf(" %d", &aSize);

    // alokacja tablicy tylu liczb całkowitych, ile zażądał użytkownik

    randomNums = (int *) malloc(aSize * sizeof(int));

    // sprawdzenie czy tablica została prawidłowo alokowana

    if (!randomNums)
    {
        printf("Nie udało się alokować tablicy!\n");
        exit(1);
    }

    // przegląda tablicę i przypisuje jej elementom
    // losowe liczby z przedziału od 1 do 500

    for (i = 0; i < aSize; i++)
    {
        randomNums[i] = (rand() % 500) + 1;
    }

    // inicjacja największej i najmniejszej wartości w celach porównawczych

    biggest = 0;
    smallest = 500;

    // przeglądanie tablicy pełnej liczb,
    // szukanie największej i  najmniejszej
    // wartości oraz sumowanie wszystkich liczb,
    // aby obliczyć średnią

    for (i = 0; i < aSize; i++)
    {
        total += randomNums[i];
        if (randomNums[i] > biggest)
        {
            biggest = randomNums[i];
        }

        if (randomNums[i] < smallest)
        {
            smallest = randomNums[i];
        }
    }

    average = ((float)total)/((float)aSize);

    printf("Największa liczba: %d.\n", biggest);
    printf("Najmniejsza liczba: %d.\n", smallest);
    printf("Średnia: %.2f.\n", average);

    // jeśli używasz funkcji malloc(), pamiętaj aby na koniec zwolnić alokowaną pamięć
    free(randomNums);

    return(0);
}
