#include <dshow.h>

int main()
{
    IGraphBuilder   *pGraph;
    IMediaControl   *pControl;
    IMediaEvent     *pEvent;
   
    CoInitialize(NULL);
    CoCreateInstance(CLSID_FilterGraph, NULL, CLSCTX_INPROC_SERVER,
                     IID_IGraphBuilder, (void **)&pGraph);
    pGraph->QueryInterface(IID_IMediaControl, (void **)&pControl);
    pGraph->QueryInterface(IID_IMediaEvent, (void **)&pEvent);
    pGraph->RenderFile(L"film.avi", NULL); // pierwszy argument jest typu wchar_t []
    pControl->Run();
    long int evCode;
    pEvent->WaitForCompletion(INFINITE, &evCode);
    pControl->Release();
    pEvent->Release();
    pGraph->Release();
    CoUninitialize();
}
