#include <iostream>

class Wektor    // wersja 0.3, okrojona
{
public:
    size_t m_rozmiar;
    int *  m_ptab;

    Wektor(size_t n)
    : m_rozmiar(n), m_ptab(new int[n])
    { }

    ~Wektor() { delete [] m_ptab; }
      
    size_t size() const     { return m_rozmiar; }
      
    int & at(int n)         { return m_ptab[n]; }
    int   at(int n) const   { return m_ptab[n]; }
    int & operator[](int n)         { return m_ptab[n]; }
    int   operator[](int n) const   { return m_ptab[n]; }
    
    void operator= (Wektor const& wek)
    {
        if (this == &wek)               // jeeli kopiujemy obiekt na samego siebie...
            return;                     // to nie mamy co robi!
	   
        if(this->m_rozmiar != wek.m_rozmiar)                   // jeli rozmiary wektorw s rne
        {
            delete [] m_ptab;                                  // zwolnienie pamici
            this->m_rozmiar = wek.m_rozmiar;                   // skopiowanie rozmiaru
            this->m_ptab = new int [this->m_rozmiar];          // rezerwacja pamici
        }
        for (size_t i = 0; i < this->m_rozmiar; i++)           // skopiowanie danych
            this->m_ptab[i] = wek.m_ptab[i];
    }
};

int main()
{
    Wektor v(10);
    Wektor w(100);
    v[1] = 10;
    v = w;             // <-- zastosowano predefiniowany operator przypisania
    w[1] = 100;
    std::cout << "wartosc v[1] = " << v[1] << "\n";
}

/*
    void operator= (Wektor const& wek)
    {
        delete [] m_ptab;                             // zwolnienie pamici
        m_rozmiar = wek.m_rozmiar;                    // skopiowanie rozmiaru
        m_ptab = new int [m_rozmiar];                 // zarezerwowanie nowej pamici
        for (size_t i = 0; i < m_rozmiar; i++)        // skopiowanie danych
            m_ptab[i] = wek.m_ptab[i];
    }
*/
