#include <iostream>
#include <string>

class Pracownik
{
public:      
    std::string imie;
    std::string nazwisko;
    int rok_urodzenia;
   
    Pracownik(std::string const& a_imie, std::string const& a_nazwisko, int a_rok)
    : imie(a_imie), nazwisko(a_nazwisko), rok_urodzenia(a_rok)
    {
        std::cout << "++ Utworzono rekord danych dla: " << imie
                  << " " << nazwisko << " (" << rok_urodzenia << ")\n";
    }
   
    Pracownik()
    : imie("Nieznany"), nazwisko ("Nieznany"), rok_urodzenia(0)
    {
        std::cout << "++ Utworzono rekord danych dla nieokreslonego pracownika\n";
    }
   
    Pracownik(Pracownik const& prac)  
    : imie(prac.imie), nazwisko(prac.nazwisko + " (kopia)"),
      rok_urodzenia(prac.rok_urodzenia)
    {
        std::cout << "++ Utworzono kopie rekordu pracownika: " << prac.imie
                  << " " << prac.nazwisko << " (" << prac.rok_urodzenia << ")\n";
    }
   
    ~Pracownik() // destruktor
    {
        std::cout << "-- Niszcze rekord danych dla: " << imie << " " << nazwisko
                  << " (" << rok_urodzenia << ")\n";
    }
};

Pracownik boss("Zenek", "Globalny", 1981);

int main()
{
    Pracownik ania("Anna", "Lokalna", 1980);
    Pracownik *pprac = new Pracownik;
    Pracownik sobowtor(ania);
    delete pprac;
    std::cout << "== koniec funkcji main\n";
}
