#include <ginac/ginac.h>
#include <sstream>

std::string pochodna_po_x (std::string const& s, std::string & komunikat)
{
    try{
        GiNaC::symbol x ("x");         // zmienna niezalena
        GiNaC::lst lista(x);           // zmienna pomocnicza
        GiNaC::ex funkcja (s, lista);             // definicja funkcji z napisu
        GiNaC::ex pochodna = funkcja.diff(x);     // obliczenie pochodnej funkcji
        komunikat.erase();             // jest OK: zerujemy kumunikat diagnostyczny
        std::ostringstream S;          // konwersja pochodnej na std::string
        S << pochodna;
        return S.str();                // OK: zwracamy pochodn w formie napisu             
    }
    catch(std::exception const& e)     // blok obsugi wyjtkw z biblioteki GiNaC
    {
        komunikat = e.what();          // przechwycenie komunikatu diagnostycznego 
    }
    return std::string();              // pusty napis sygnalizuje wystpienie bdu
}

int main()
{
    std::string funkcja, pochodna, komunikat;   
    for ( ; ; )
    {
        std::cout << "Wprowad funkcj zmiennej x:\nf(x) = ";
        std::getline(std::cin, funkcja);                    // wczytanie funkcji
        pochodna = pochodna_po_x (funkcja, komunikat);
        if (!pochodna.empty())
            break;
        std::cerr <<  "--- Error: \"" << komunikat << "\" ---\n\n";
    }
    std::cout << "funkcja  = " << funkcja << "\n";
    std::cout << "pochodna = " << pochodna << "\n";  
}

/*
Wprowad funkcj zmiennej x:
f(x) = arcsin(x)
--- Error: "no function 'arcsin' with 1 parameters defined" ---

Wprowad funkcj zmiennej x:
f(x) = asin(x*y)
--- Error: "unknown symbol 'y'" ---

Wprowad funkcj zmiennej x:
f(x) = asin(x*x)
funkcja  = asin(x*x)
pochodna = 2*(1-x^4)^(-1/2)*x
*/
