#include <iostream>

#define DEFINE_WEKTOR(T)                                                  \
class Wektor_##T                                                          \
{                                                                         \
    size_t const m_rozmiar;                                               \
    T*  const m_ptab;                                                     \
public:                                                                   \
    Wektor_##T(size_t n) : m_rozmiar(n), m_ptab(new T[n])  { }            \
    ~Wektor_##T() { delete [] m_ptab; }                                   \
    size_t size() const   { return m_rozmiar; }                           \
    T & at(int n)         { return m_ptab[n]; }                           \
    T   at(int n) const   { return m_ptab[n]; }                           \
};

DEFINE_WEKTOR(double);             // definicja klasy Wektor_double
DEFINE_WEKTOR(int);                // definicja klasy Wektor_int

int main()
{
    Wektor_double v(10);     // wektor 10 elementw typu double
    Wektor_int w(20);        // wektor 20 elementw typu int
    v.at(5) = w.at(5) = 1;
    std::cout << "v.size() = " << v.size() << "\n";
    std::cout << "w.size() = " << w.size() << "\n";
}
