#include <iostream>
#include <cmath>

int fibo1(int n)
{
    if (n <= 2)   
        return 1;
    else
        return fibo1(n-1) + fibo1(n-2);
}

int fibo2(int n)
{
    const double sqrt5 = sqrt(5.0);   
    const double lambda1 = 2.0/(sqrt5 - 1.0);       
    const double lambda2 = -2.0/(sqrt5 + 1.0);
    return  (0.5+(std::pow(lambda1, n) - std::pow(lambda2, n))/sqrt5 ); 
}


int main()
{
    for (int i = 1; i <= 48; i++)
    {
        int f1 = fibo1(i);
        int f2 = fibo2(i);
        std::cout << i << "\t" << f1 << "\t" 
                  << f2 << "\t" << f1 - f2 << "\n";
    }
}
