// Program kopiujący jeden plik na drugi, 2. wersja

#include <stdio.h>

int main (int argc, char *argv[])
{
    FILE  *in, *out;
    int   c;

    if ( argc != 3 ) {
        fprintf (stderr, "Wymagane są nazwy dwóch plików\n");
        return 1;
    }

    if ( (in = fopen (argv[1], "r")) == NULL ) {
        fprintf (stderr, "Nie mogę odczytać %s.\n", argv[1]);
        return 2;
    }

    if ( (out = fopen (argv[2], "w")) == NULL ) {
        fprintf (stderr, "Nie mogę pisać do %s.\n", argv[2]);
        return 3;
    }

    while ( (c = getc (in)) != EOF )
        putc (c, out);

    printf ("Przekopiowano wskazany plik.\n");

    fclose (in);
    fclose (out);

    return 0;
}
