/*
 * Kolejna wersja projektu zawierajca wiksz abstrakcj. Wci jednak uywamy tej samej podstawowej konfiguracji,
 * jak w przypadku projektu car0. W tym uyjemy kilku dodatkowych funkcji w ramach przygotowa do utworzenia biblioteki,
 * a docelowo do obsugi zdalnego sterowania za pomoc radia.
 */

#include "pins.h"

// Zdefiniuj typ odpowiadajcy kierunkowi poruszania si
typedef char direction_t;

// Zdefiniuj stae odpowiadajce kierunkom poruszania si i brakowi ruchu
const direction_t STOP     = 0;
const direction_t LEFT     = 1;
const direction_t RIGHT    = 2;
const direction_t FORWARD  = 3;
const direction_t BACKWARD = 4;

void setup() {
  // Poinformuj pytk, e chcemy wywietla wbudowan diod LED
  pinMode(LED_BUILTIN, OUTPUT);

  // Zdefiniuj wejcia dla wyprowadze dojstika
  pinMode(LEFT_BTN, INPUT_PULLUP);
  pinMode(RIGHT_BTN, INPUT_PULLUP);
  pinMode(FWD_BTN, INPUT_PULLUP);
  pinMode(BKWD_BTN, INPUT_PULLUP);

  // Zdefiniuj wyjcia sterujce silniczkiem
  pinMode(AIN1, OUTPUT);
  pinMode(AIN2, OUTPUT);
  pinMode(BIN1, OUTPUT);
  pinMode(BIN2, OUTPUT);

  // Upewnij si, e dioda LED jest na razie wyczona
  digitalWrite(LED_BUILTIN, LOW);
}

direction_t readDirection() {
  if (digitalRead(FWD_BTN) == LOW) {
    return FORWARD;
  }
  if (digitalRead(BKWD_BTN) == LOW) {
    return BACKWARD;
  }
  if (digitalRead(LEFT_BTN) == LOW) {
    return LEFT;
  }
  if (digitalRead(RIGHT_BTN) == LOW) {
    return RIGHT;
  }
  // Nie nacinito adnego z przyciskw, wic zwracamy STOP
  return STOP;
}

void loop() {
  direction_t dir = readDirection();
  if (dir > 0) { // Ruch!
    digitalWrite(LED_BUILTIN, HIGH);
    switch (dir) {
      case FORWARD:
        forward();
        break;
      case BACKWARD:
        backward();
        break;
      case LEFT:
        left();
        break;
      case RIGHT:
        right();
        break;
    }
  } else {
    // Przerwanie jazdy (w tym miejscu mona rwnie obsuy bdy)
    digitalWrite(LED_BUILTIN, LOW);
    allstop();
  }
}
