#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

struct account {
  char name[50];
  double balance;
};

struct account *create(char *name, double initial) {
  struct account *acct = malloc(sizeof(struct account));
  strncpy(acct->name, name, 49);
  acct->balance = initial;
  return acct;
}

void print(struct account *a) {
  printf("Konto: %s\n", a->name);
  printf("Saldo: %.2f z\n", a->balance);
}

void add_interest(struct account *acct, double rate, int months) {
  // Zapisz biece saldo w zmiennej lokalnej, aby uatwi sobie prac
  double principal = acct->balance;
  // Przekszta stawk roczn na miesiczn warto procentow
  rate /= 1200;
  // Uyj wzoru do wyznaczania miesicznych odsetek skadanych, aby obliczy now warto salda
  acct->balance = principal * pow(1 + rate, months);
}

int main() {
  struct account *checking;
  checking = create("Zygmunt Kataski", 200.0);
  print(checking);

  add_interest(checking, 5.0, 12);
  print(checking);

  free(checking);
}

