// Doczamy standardowy nagwek stdio, a take stdlib, aby uzyska dostp
// do funkcji malloc() i free(), a take wartoci NULL
#include <stdio.h>
#include <stdlib.h>

// Uywamy sowa kluczowego struct, by stworzy nowe typy kompozytowe
struct transaction {
  double amount;
  int month, day, year;
};

// Nowo utworzony typ moe zosta uyty jako parametr funkcji
void printTransaction1(struct transaction tx) {
  printf("%2d.%02d.%4d: %10.2f\n", tx.day, tx.month, tx.year, tx.amount);
}

// Moemy rwnie przekaza wskanik do struktury
void printTransaction2(struct transaction *ptr) {
  // Test, czy wskanik nie jest pusty
  if (ptr == NULL) {
    printf("Invalid transaction.\n");
  } else {
    // W porzdku! Mamy transakcj, wywietlmy wic jej szczegy za pomoc operatora ->
    printf("%2d.%02d.%4d: %10.2f\n", ptr->day, ptr->month, ptr->year, ptr->amount);
  }
}

// Przekazanie wskanika do funkcji umoliwia w razie potrzeby
// modyfikowanie zawartoci struktury
void addTax(struct transaction *ptr, double rate) {
  double tax = ptr->amount * rate;
  ptr->amount += tax;
}

int main() {
  // Moemy zadeklarowa zmienne lokalne (lub globalne) o nowo utworzonym typie
  struct transaction bill;

  // Wartoci pocztkowe umieszczamy wewntrz nawiasw klamrowych
  struct transaction deposit = { 200.00, 6, 20, 2021 };

  // Moemy take zainicjalizowa skadowe struktury w dowolnej kolejnoci za pomoc operatora kropki
  bill.amount = 56.75;
  bill.month = 7;
  bill.day = 15;
  bill.year = 2021;

  // Struktury przekazujemy do funkcji tak, jak inne zmienne
  printTransaction1(deposit);
  printTransaction1(bill);

  // Moemy rwnie utworzy wskaniki do struktur i przydzieli pami za pomoc funkcji malloc()
  struct transaction tmp = { 68.91, 8, 1, 2020 };
  struct transaction *payment = NULL;
  struct transaction *withdrawal;
  payment = &tmp;
  withdrawal = malloc(sizeof(struct transaction));

  // Do skomplikowane wyuskanie w celu uzyskania dostpu do skadowej
  (*withdrawal).amount = -20.0;
  // Prostsza metoda: uycie operatora strzaki
  withdrawal->day = 3;
  withdrawal->month = 8;
  withdrawal->year = 2021;

  // Wskaniki do struktur mona przekazywa do funkcji
  printTransaction2(payment);
  printTransaction2(withdrawal);

  // Dodajemy podatek do rachunku za pomoc funkcji i przekazanego do niej wskanika
  printf("Rachunek przed uwzgldnieniem podatku: $%.2f\n", bill.amount);
  addTax(&bill, 0.05);
  printf("Rachunek po uwzgldnieniu podatku: $%.2f\n", bill.amount);

  // Na kocu trzeba zawsze zwolni przydzielon pami
  free(withdrawal);
}