#include <stdio.h>

int str2int(char *digits) {
  int end = -1;
  // Wyszukaj koniec acucha
  while (digits[end + 1] != '\0') {
    end++;
  }

  // Przekszta cyfr po prawej stronie na liczb
  // przy uyciu operacji matematycznych na znakach ASCII.
  // Nastpnie przejd do kolejnej cyfry. Przekszta j,
  // ale rwnie pomn przez 10. Trzeci wynik pomn przez 100 itd.
  int multiplier = 1;
  int result = 0;
  for (int d = end; d >= 0; d--) {
    if (digits[d] >= '0' && digits[d] <= '9') {
      // Mamy do czynienia z poprawn cyfr
      int asNumber = digits[d] - '0';

      // Dodaj j do wyniku pamitajc o uwzgldnieniu odpowiedniej potgi liczby 10
      result += (asNumber * multiplier);

      // Przygotuj mnonik dla kolejnej cyfry
      multiplier *= 10;
    } else {
      // Problem, znak nie jest cyfr! Koniec przetwarzania
      break;
    }
  }
  return result;
}

int main(int argc, char *argv[]) {
  int total = 0;
  for (int i = 1; i < argc; i++) {
    total += str2int(argv[i]);
  }
  printf("Suma %d liczb wynosi %d\n", argc - 1, total);
}