#include <stdio.h>

int main() {
  // rozmiar tablicy i liczba jej elementów powinny sobie odpowiadać
  int days_in_month[12] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };

  // rozmiar tablicy może zostać obliczony przez kompilator na podstawie zawartości
  char vowels[] = { 'a', 'ą', 'e', 'ę', 'i', 'o', 'u', 'y' };
  float readings[] = { 8.9, 8.6, 8.5, 8.7, 8.9, 8.8, 8.5 };

  // rozmiar może być także większy od liczby elementów inicjalizacyjnych i przewidywać miejsce pozwalające na wypełnienie w przyszłości
  float more_readings[10] = { 8.9, 8.6 };

  // Specjalny sposób inicjalizowania tablicy znakowej za pomocą literału łańcuchowego
  char secret[] = "hasło1";
  char downloads[] = "C:\\Downloads";

  printf("Drugą samogłoską jest: %c\n", vowels[1]);
  printf("Lipiec ma %d dni.\n", days_in_month[6]);

  int month = 7;
  printf("Lipiec (miesiąc %d) has %d days.\n", month, days_in_month[month - 1]);
  
  month = 15;
  printf("Błędny miesiąc (o numerze %d) ma %d dni.\n", month, days_in_month[month - 1]);

  more_readings[7] = 8.4;
  more_readings[8] = 'x';
  printf("Poprawny odczyt: %.1f, błędny odczyt: %.1f\n", more_readings[7], more_readings[8]);

  for (int m = 0; m < 12; m++) {
    // pamiętaj, że indeksy w tablicy rozpoczynają się od wartości 0, ale ludzie zazwyczaj rozpoczynają od 1
    printf("Liczba dni w miesiącu %d. wynosi %d.\n", m + 1, days_in_month[m]);
  }

  // Wykorzystaj operator sizeof, aby wyznaczyć liczbę elementów
  int count = sizeof(readings) / sizeof(float);

  float total = 0.0;
  float average;
  int smallestIndex = 0;    
  float largestValue = -1.0; 
  for (int r = 0; r < count; r++) {
    total += readings[r];
    if (readings[r] < readings[smallestIndex]) {
      smallestIndex = r;
    }
    if (readings[r] > largestValue) {
      largestValue = readings[r];
    }
  }
  average = total / count;
  printf("Wartość średnia: %0.2f\n", average);
  printf("Wartość najmniejsza: %.1f (index %i)\n", readings[smallestIndex], smallestIndex);
  printf("Wartość największa: %.1f\n", largestValue);

}