/*
 * Kod urzdzenia sterujcego dla finalnego projektu zdalnie sterowanego samochodu.
 * Projekt ten wsppracuje z projektem car3 (oraz bibliotek SmalleRC).
 * Usunlimy przewody dojstika, a zaimplementowalimy poczenie radiowe. Dojstik sprawdzamy tak jak poprzednio,
 * ale zamiast bezporednio sterowa silnikiem, poprzez radio wysyamy wybrany kierunek.
 */

#include "SmalleRC.h"

#define LEFT_BTN  9
#define RIGHT_BTN 7
#define FWD_BTN   8
#define BKWD_BTN  6

void setup() {
  Serial.begin(115200);
  // Zdefiniuj wejcia dla wyprowadze dojstika
  pinMode(LEFT_BTN, INPUT_PULLUP);
  pinMode(RIGHT_BTN, INPUT_PULLUP);
  pinMode(FWD_BTN, INPUT_PULLUP);
  pinMode(BKWD_BTN, INPUT_PULLUP);

  if (rc_start() != rc_INIT_SUCCESS) {
    Serial.println("Problem z inicjalizacj moduu radiowego.");
  }
}

direction_t readDirection() {
  if (digitalRead(FWD_BTN) == LOW) {
    return rc_FORWARD;
  }
  if (digitalRead(BKWD_BTN) == LOW) {
    return rc_BACKWARD;
  }
  if (digitalRead(LEFT_BTN) == LOW) {
    return rc_LEFT;
  }
  if (digitalRead(RIGHT_BTN) == LOW) {
    return rc_RIGHT;
  }
  // aden przycisk nie zosta nacinity, wic zwracamy STOP
  return rc_STOP;
}

void loop() {
  direction_t dir = readDirection();
  rc_send(dir);
  delay(10);
}
