// Efekt "oddychania" diody RGB LED

// Upewnienie si, e wyprowadzenia wyjciowe wspieraj PWM
// https://www.arduino.cc/reference/en/language/functions/analog-io/analogwrite/
#define RED    5
#define GREEN  6
#define BLUE   9

// Pewne wartoci pomocnicze
#define RATE 5000
#define PI_2 6.283185

// Kanay kolorw dla diody RGB LED
byte red;
byte green;
byte blue;

void setup() {
  Serial.begin(115200);
  // Konfiguracja wyprowadze wyjciowych
  pinMode(RED, OUTPUT);
  pinMode(GREEN, OUTPUT);
  pinMode(BLUE, OUTPUT);
  // Na pocztku dioda wyczona
  digitalWrite(RED, 0);
  digitalWrite(GREEN, 0);
  digitalWrite(BLUE, 0);
  // Ustawienie ziarna generatora losowego
  randomSeed(analogRead(0));
  // Zdefiniowanie losowego koloru i upewnienie si, e jest stosunkowo jasny
  red = random(128,255);
  green = random(128,255);
  blue = random(128,255);
  // Wywietlenie wartoci kolorw w postaci szesnastkowej za pomoc portu szeregowego
  Serial.print(red, HEX);
  Serial.print(green, HEX);
  Serial.println(blue, HEX);
  // Przesanie koloru do diody LED na kilka sekund przed rozpoczciem animacji
  analogWrite(RED, red);
  analogWrite(GREEN, green);
  analogWrite(BLUE, blue);
  delay(RATE);
}

void loop() {
  double ms_in_radians = (millis() % RATE) * PI_2 / RATE;
  double breath = (sin(ms_in_radians) + 1.0) / 2.0;
  analogWrite(RED, red * breath);
  analogWrite(GREEN, green * breath);
  analogWrite(BLUE, blue * breath);
  delay(10);
}
