/*
 * Ostateczna wersja projektu zdalnie sterowanego samochodu. Jest ona poczona z projektem "urzdzenia sterujcego".
 * Usunlimy przewody dojstika, a zamiast tego za pomoc moduu radiowego sprawdzamy, czy zostay przesane wartoci kierunkw,
 * ktre nastpnie wykorzystujemy do sterowania samochodem.
 */

#include "pins.h"
#include "SmalleRC.h"

void setup() {
  Serial.begin(115200);
  // Zdefiniuj wyjcia sterujce silniczkiem
  pinMode(AIN1, OUTPUT);
  pinMode(AIN2, OUTPUT);
  pinMode(BIN1, OUTPUT);
  pinMode(BIN2, OUTPUT);

  if (rc_start() != rc_INIT_SUCCESS) {
    Serial.println("Problem z inicjalizacj moduu radiowego.");
  }
}

void loop() {
  direction_t dir = rc_receive();
  if (dir > 0) { // Jazda!
    switch (dir) {
      case rc_FORWARD:
        forward();
        break;
      case rc_BACKWARD:
        backward();
        break;
      case rc_LEFT:
        left();
        break;
      case rc_RIGHT:
        right();
        break;
    }
    delay(20);
  } else {
    // Przerwanie jazdy (w tym miejscu mona rwnie obsuy bdy)
    allstop();
  }
}
