/*
 * Decompiled with CFR 0.152.
 */
package com.packtpub.as7development.chapter3.ejb;

import com.packtpub.as7development.chapter3.model.Seat;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.jboss.logging.Logger;

@Singleton
@Startup
public class TheatreBox {
    private ArrayList<Seat> seatList;
    private static final Logger logger = Logger.getLogger(TheatreBox.class);

    @PostConstruct
    public void setupTheatre() {
        Seat seat;
        int i;
        this.seatList = new ArrayList();
        int id = 0;
        for (i = 0; i < 5; ++i) {
            seat = new Seat(++id, "Parter", 40);
            this.seatList.add(seat);
        }
        for (i = 0; i < 5; ++i) {
            seat = new Seat(++id, "Balkon I", 20);
            this.seatList.add(seat);
        }
        for (i = 0; i < 5; ++i) {
            seat = new Seat(++id, "Balkon II", 10);
            this.seatList.add(seat);
        }
        logger.info((Object)"Utworzono list\u0119 miejsc.");
    }

    @Lock(value=LockType.READ)
    public ArrayList<Seat> getSeatList() {
        return this.seatList;
    }

    @Lock(value=LockType.READ)
    public int getSeatPrice(int id) {
        return this.getSeatList().get(id).getPrice();
    }

    @Lock(value=LockType.WRITE)
    public void buyTicket(int seatId) {
        Seat seat = this.getSeatList().get(seatId);
        seat.setBooked(true);
    }
}

