/*
 * Decompiled with CFR 0.152.
 */
package com.packtpub.as7development.chapter3.ejb;

import com.packtpub.as7development.chapter3.ejb.TheatreBooker;
import com.packtpub.as7development.chapter3.ejb.TheatreBox;
import com.packtpub.as7development.chapter3.exception.NotEnoughMoneyException;
import com.packtpub.as7development.chapter3.exception.SeatBookedException;
import com.packtpub.as7development.chapter3.model.Seat;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.ejb.AsyncResult;
import javax.ejb.Asynchronous;
import javax.ejb.EJB;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import org.jboss.logging.Logger;

@Stateful
@Remote(value={TheatreBooker.class})
public class TheatreBookerBean
implements TheatreBooker {
    private static final Logger logger = Logger.getLogger(TheatreBookerBean.class);
    int money;
    @EJB
    TheatreBox theatreBox;

    @PostConstruct
    public void createCustomer() {
        this.money = 100;
    }

    @Override
    public String bookSeat(int seatId) throws SeatBookedException, NotEnoughMoneyException {
        Seat seat = this.theatreBox.getSeatList().get(seatId);
        if (seat.isBooked()) {
            throw new SeatBookedException("To miejsce jest ju\u017c zarezerwowane!");
        }
        if (seat.getPrice() > this.money) {
            throw new NotEnoughMoneyException("Nie masz wystarczaj\u0105cych \u015brodk\u00f3w, by kupi\u0107 ten bilet!");
        }
        this.theatreBox.buyTicket(seatId);
        this.money -= seat.getPrice();
        logger.info((Object)"Rezerwacja przyj\u0119ta.");
        return "Rezerwacja przyj\u0119ta.";
    }

    @Override
    @Asynchronous
    public Future<String> bookSeatAsync(int seatId) {
        Seat seat = this.theatreBox.getSeatList().get(seatId);
        if (seat.isBooked()) {
            return new AsyncResult((Object)("Miejsce " + seatId + " jest ju\u017c zarezerwowane!"));
        }
        if (seat.getPrice() > this.money) {
            return new AsyncResult((Object)"Nie masz wystarczaj\u0105cych \u015brodk\u00f3w, by kupi\u0107 ten bilet!");
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        logger.info((Object)"Rezerwacja przyj\u0119ta.");
        this.theatreBox.buyTicket(seatId);
        this.money -= seat.getPrice();
        return new AsyncResult((Object)("Zarezerowane miejsce: " + seat + " - Pozosta\u0142o pieni\u0119dzy: " + this.money));
    }
}

