import java.util.ArrayList;
import java.sql.*;

/**
 * Klasa CoffeeDBManager wykonuje operacje
 * na bazie danych CoffeeDB.
 */

public class CoffeeDBManager
{
   // Staa z adresem URL bazy.
   public final static String DB_URL = "jdbc:derby:CoffeeDB";

   /**
    * Metoda getCustomerNames zwraca obiekt typu ArrayList
    *  z elementami typu String zawierajcymi nazwy wszystkich klientw.
    */ 
   public static ArrayList<String> getCustomerNames() throws SQLException
   {
      // Nawizywanie poczenia z baz danych.
      Connection conn = DriverManager.getConnection(DB_URL);
      
      // Nawizywanie poczenia z baz danych.
      conn = DriverManager.getConnection(DB_URL);
               
      // Tworzenie obiektu typu Statement zawierajcego zapytanie.
      Statement stmt =
         conn.createStatement(
                 ResultSet.TYPE_SCROLL_SENSITIVE,
                 ResultSet.CONCUR_READ_ONLY);
            
      // Wykonywanie zapytania.
      ResultSet resultSet = stmt.executeQuery(
                          "SELECT Name FROM Customer");
               
      // Pobieranie liczby wierszy.
      resultSet.last();                  // Przejcie do ostatniego wiersza.
      int numRows = resultSet.getRow();  // Pobranie numeru wiersza.
      resultSet.first();                 // Przejcie do pierwszego wiersza.

      // Tworzenie obiektu typu ArrayList z nazwami klientw.
      ArrayList<String> listData = new ArrayList<>();
      
      // Zapenianie obiektu typu ArrayList nazwami klientw.
      for (int index = 0; index < numRows; index++)
      {
         // Zapisywanie nazwy klienta w tablicy.
         listData.add(resultSet.getString(1));

         // Przechodzenie do nastpnego wiersza zbioru wynikw.
         resultSet.next();
      }
      
      // Zamykanie poczenia i obiektu stmt.
      conn.close();
      stmt.close();

      // Zwracanie tablicy listData.
      return listData;
   }

   /**
    * Metoda getCoffeeNames zwraca tablic 
    * elementw typu String zawierajcych nazwy wszystkich kaw.
    */
   public static ArrayList<String> getCoffeeNames() throws SQLException
   {
      // Nawizywanie poczenia z baz danych.
      Connection conn = DriverManager.getConnection(DB_URL);
      
      // Tworzenie obiektu typu Statement zawierajcego zapytanie.
      Statement stmt =
         conn.createStatement(
                 ResultSet.TYPE_SCROLL_SENSITIVE,
                 ResultSet.CONCUR_READ_ONLY);
            
      // Wykonywanie zapytania.
      ResultSet resultSet = stmt.executeQuery(
                       "SELECT Description FROM Coffee");
               
      // Pobieranie liczby wierszy.
      resultSet.last();                 // Przejcie do ostatniego wiersza.
      int numRows = resultSet.getRow(); // Pobranie numeru wiersza.
      resultSet.first();                // Przejcie do pierwszego wiersza.

      // Tworzenie tablicy z nazwami kaw.
      ArrayList<String> listData = new ArrayList<>();
      
      // Zapenianie tablicy nazwami kaw.
      for (int index = 0; index < numRows; index++)
      {
         // Zapisywanie nazwy kawy w tablicy.
         listData.add(resultSet.getString(1));

         // Przejcie do nastpnego wiersza w zbiorze wynikw.
         resultSet.next();
      }
      
      // Zamykanie poczenia i obiektu stmt.
      conn.close();
      stmt.close();

      // Zwracanie tablicy listData.
      return listData;
   }

   /**
    * Metoda getProdNum zwraca
    * numer produktu okrelonej kawy.
    */  
   public static String getProdNum(String coffeeName) throws SQLException
   {
      String prodNum = ""; // Numer produktu.
      
      // Nawizywanie poczenia z baz.
      Connection conn = DriverManager.getConnection(DB_URL);
               
      // Tworzenie obiektu typu Statement zawierajcego zapytanie.
      Statement stmt = conn.createStatement();
            
      // Wykonywanie zapytania.
      ResultSet resultSet = stmt.executeQuery(
                          "SELECT ProdNum " +
                          "FROM Coffee " +
                          "WHERE Description = '" + 
                          coffeeName + "'");
               
      // Jeli w zbiorze wynikw znajduje si kolejny wiersz,
      // program przechodzi do niego i pobiera numer produktu.
      if (resultSet.next())
         prodNum = resultSet.getString(1);
   
      // Zamykanie poczenia i obiektu stmt.
      conn.close();
      stmt.close();

      // Zwracanie numeru produktu.
      return prodNum;
   }

   /**
    * Metoda getCoffeePrice zwraca
    * cen kawy.
    */
   public static double getCoffeePrice(String prodNum) throws SQLException
   {
      double price = 0.0;  // Cena kawy.
      
      // Nawizywanie poczenia z baz.
      Connection conn = DriverManager.getConnection(DB_URL);
               
      // Tworzenie obiektu typu Statement zawierajcego zapytanie.
      Statement stmt = conn.createStatement();
            
      // Wykonywanie zapytania.
      ResultSet resultSet = stmt.executeQuery(
                          "SELECT Price " +
                          "FROM Coffee " +
                          "WHERE ProdNum = '" + 
                          prodNum + "'");

      // Jeli w zbiorze wynikw znajduje si kolejny wiersz, 
      // program przechodzi do niego i pobiera cen.    
      if (resultSet.next())
         price = resultSet.getDouble(1);
   
      // Zamykanie poczenia i obiektu stmt.
      conn.close();
      stmt.close();

      // Zwracanie ceny.
      return price;
   }

   /**
    * Metoda getCustomerNum zwraca numer
    * okrelonego klienta.
    */  
   public static String getCustomerNum(String name) throws SQLException
   {
      String customerNumber = "";
      
      // Nawizywanie poczenia z baz danych.
      Connection conn = DriverManager.getConnection(DB_URL);
               
      // Tworzenie obiektu typu Statement zawierajcego zapytanie.
      Statement stmt = conn.createStatement();
            
      // Wykonywanie zapytania.
      ResultSet resultSet = stmt.executeQuery(
                          "SELECT CustomerNumber " +
                          "FROM Customer " +
                          "WHERE Name = '" + name + "'");
               
      if (resultSet.next())
         customerNumber = resultSet.getString(1);
   
      // Zamykanie poczenia i obiektu stmt.
      conn.close();
      stmt.close();

      // Zwracanie numeru klienta.
      return customerNumber;
   }

   /**
    * Metoda submitOrder przesya zamwienie
    * do tabeli UnpaidOrder z bazy danych CoffeeDB.
    */
   public static void submitOrder(String custNum, String prodNum,
                                  int quantity, double price, 
                                  String orderDate) throws SQLException
   {
      // Obliczanie wartoci zamwienia.
      double cost = quantity * price;

      // Nawizywanie poczenia z baz danych.
      Connection conn = DriverManager.getConnection(DB_URL);
               
      // Tworzenie obiektu typu Statement zawierajcego zamwienie.
      Statement stmt = conn.createStatement();           

      // Wykonywanie zapytania.
      stmt.executeUpdate("INSERT INTO UnpaidOrder VALUES('" +
                         custNum + "', '" +
                         prodNum + "', '" + orderDate + "', " +
                         quantity + ", " + cost + ")");
               
      // Zamykanie poczenia i obiektu stmt.
      conn.close();
      stmt.close();
   }
}
