import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.geometry.Pos;
import javafx.geometry.Insets;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.control.Button;
import java.io.File;

public class SoundPlayer extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Wczytywanie pliku dwikowego i tworzenie obiektu typu MediaPlayer.
      File soundFile = new File("guitar.wav");
      Media media = new Media(soundFile.toURI().toString());
      MediaPlayer player = new MediaPlayer(media);
      
      // Obiekt obsugi zdarze OnEndOfMedia.
      player.setOnEndOfMedia(() ->
      {
         player.stop();
      });
      
      // Tworzenie przyciskw.
      Button playButton = new Button("Odtwrz");
      Button pauseButton = new Button("Wstrzymaj");
      Button stopButton = new Button("Zatrzymaj");
      
      // Obiekt obsugi zdarze dla przycisku Odtwrz.
      playButton.setOnAction(event ->
      {
         player.play();
      });

      // Obiekt obsugi zdarze dla przycisku Wstrzymaj.
      pauseButton.setOnAction(event ->
      {
         player.pause();
      });

      // Obiekt obsugi zdarze dla przycisku Zatrzymaj.
      stopButton.setOnAction(event ->
      {
         player.stop();
      });
      
      // Umieszczanie przyciskw w kontenerze typu HBox.
      HBox hbox = new HBox(10, playButton, pauseButton, stopButton);
      hbox.setAlignment(Pos.CENTER);
      hbox.setPadding(new Insets(10));
      
      // Tworzenie sceny z kontenerem typu HBox jako wzem korzenia.
      Scene scene = new Scene(hbox);
      
      // Dodawanie sceny do ptna i wywietlanie okna.
      primaryStage.setScene(scene);
      primaryStage.show();
   }
}