import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.shape.Circle;
import javafx.scene.paint.Color;
import javafx.scene.layout.Pane;
import javafx.event.EventHandler;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.KeyCode;

public class MoveBall extends Application
{
   public static void main(String[] args)
   {
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Stae okrelajce wielko sceny.
      final double SCENE_WIDTH = 200.0;
      final double SCENE_HEIGHT = 200.0;
      
      // Stae dotyczce koa.
      final double START_X = 100.0, START_Y = 40.0;
      final double RADIUS = 40.0;
      final double STEP = 10.0;
      
      // Tworzenie koa.
      Circle ball = new Circle(START_X, START_Y, RADIUS);
      ball.setFill(Color.RED);
      
      // Dodawanie koa do kontenera typu Pane.
      Pane pane = new Pane(ball);
      
      // Tworzenie sceny i jej wywietlanie.
      Scene scene = new Scene(pane, SCENE_WIDTH, SCENE_HEIGHT);
      
      // Rejestrowanie dla sceny obiektu obsugi zdarze typu KEY_PRESSED.
      scene.setOnKeyPressed(event ->
      {
         // Pobieranie wsprzdnych koa.
         double x = ball.getCenterX();
         double y = ball.getCenterY();
         
         // Sprawdzanie, czy wcinito strzak w d.
         if (event.getCode() == KeyCode.DOWN && 
             y < (SCENE_HEIGHT - RADIUS))
         {
            ball.setCenterY(y + STEP);
         }
         
         // Sprawdzanie, czy wcinito strzak w gr.
         if (event.getCode() == KeyCode.UP && 
             y > RADIUS)
         {
            ball.setCenterY(y - STEP);
         }
         
         // Sprawdzanie, czy wcinito strzak w prawo.
         if (event.getCode() == KeyCode.RIGHT && 
             x < (SCENE_WIDTH - RADIUS))
         {
            ball.setCenterX(x + STEP);
         }
         
         // Sprawdzanie, czy wcinito strzak w lewo.
         if (event.getCode() == KeyCode.LEFT && 
             x > RADIUS)
         {
            ball.setCenterX(x - STEP);
         }
      });

      // Przypisywanie sceny do ptna i jej wywietlanie.
      primaryStage.setScene(scene);
      primaryStage.show();
   }
}