import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.layout.BorderPane;
import javafx.geometry.Pos;

/**
 *  Aplikacja BorderPaneDemo2.
 */

public class BorderPaneDemo2 extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie przyciskw.
      Button centerButton = new Button("rodkowy obszar");
      Button topButton = new Button("Grny obszar");
      Button bottomButton = new Button("Dolny obszar");
      Button leftButton = new Button("Lewy obszar");
      Button rightButton = new Button("Prawy obszar");
      
      // Dodawanie kadego przycisku do odrbnego kontenera.
      HBox centerHBox = new HBox(centerButton);
      HBox topHBox = new HBox(topButton);
      HBox bottomHBox = new HBox(bottomButton);
      VBox leftVBox = new VBox(leftButton);
      VBox rightVBox = new VBox(rightButton);

      // Wyrwnywanie kontrolek w kontenerach grnym i dolnym.
      topHBox.setAlignment(Pos.CENTER);
      bottomHBox.setAlignment(Pos.CENTER);
      
      // Tworzenie kontenera typu BorderPane z wzem porodku.
      BorderPane borderPane = new BorderPane(centerHBox);
      
      // Dodawanie przyciskw do obszarw kontenera typu BorderPane.
      borderPane.setTop(topHBox);
      borderPane.setBottom(bottomHBox);
      borderPane.setLeft(leftVBox);
      borderPane.setRight(rightVBox);

      // Tworzenie obiektu typu Scene z kontenerem typu BorderPane jako wzem korzenia.
      Scene scene = new Scene(borderPane);

      // Dodawanie obiektu typu Scene do obiektu typu Stage.
      primaryStage.setScene(scene);

      // Wywietlanie okna.
      primaryStage.show();
   }
}