import java.io.*;    // Umoliwia uywanie klas File i FileNotFoundException.
import java.util.*;             // Umoliwia uywanie klas Scanner i InputMismatchException.
import javax.swing.JOptionPane; // Umoliwia uywanie klasy JOptionPane.

/**
   Ten program pokazuje, jak zastosowa bloki obsugi
   wyjtkw do przywracania stanu po bdach.
 */
  
 public class SalesReport2
 {
    public static void main(String[] args)
    {
       String filename = "SalesData.txt"; // Nazwa pliku.
       int months = 0;                    // Licznik miesicy.
       double oneMonth;                   // Warto sprzeday z danego miesica.
       double totalSales = 0.0;           // czna warto sprzeday.
       double averageSales;               // rednia sprzeda.

       // Prba otwarcia pliku za pomoc wywoania
       // metody openFile.
       Scanner inputFile = openFile(filename);
       
       // Jeli metoda openFile zwrcia warto null, to
       // pliku nie znaleziono. Naley pobra now nazw pliku.
       while (inputFile == null)
       {
         filename = JOptionPane.showInputDialog(
                       "BD: " + filename +
                       " nie istnieje.\n" +
                       "Podaj inn nazw pliku: ");
         inputFile = openFile(filename);
       }
 
       // Przetwarzanie zawartoci pliku.
     while (inputFile.hasNext())
     {
       try
       {
         // Pobieranie wartoci sprzeday z danego miesica.
         oneMonth = inputFile.nextDouble();

         // Dodawanie wartoci sprzeday do sumy.
         totalSales += oneMonth;

         // Inkrementacja licznika miesicy.
             months++;
          }
          catch(InputMismatchException e)
          {
             // Wywietlanie komunikatu o bdzie.
             JOptionPane.showMessageDialog(null,
               "W pliku znaleziono dane niebdce liczb.\n" +
               "Bdne dane zostan pominite.");

             // Pomijanie bdnych danych.
             inputFile.nextLine();
          }
       }
 
       // Zamykanie pliku.
       inputFile.close();

     // Obliczanie redniej.
     averageSales = totalSales / months;

     // Wywietlanie wynikw.
     JOptionPane.showMessageDialog(null,
        String.format("Liczba miesicy: %d\n" +
                      "czna sprzeda: %,.2f zotych\n" +
                      "rednia sprzeda: %,.2f zotych",
                        months, totalSales, averageSales));
                        
       System.exit(0);
    }
 
    /**
       Metoda openFile otwiera podany plik i 
       zwraca referencj do obiektu typu Scanner.
       @param filename Nazwa otwieranego pliku.
       @return Referencja do obiektu typu Scanner, jeli podany
               plik istnieje; w przeciwnym razie warto null.
    */
 
    public static Scanner openFile(String filename)
    {
       Scanner scan;
 
       // Prba otwarcia pliku.
       try
       {
          File file = new File(filename);
          scan = new Scanner(file);
       }
       catch(FileNotFoundException e)
       {
          scan = null;
       }
 
       return scan;
    }
 }
