import java.util.Random;

/**
   Klasa Die symuluje kostk do gry.
*/

public class Die
{
   private final int MIN_SIDES = 4;
   private int sides;   // Liczba cianek.
   private int value; // Wyrzucona warto.

   /**
     Konstruktor wykonuje wstpny
     rzut kostk.
     @param numSides Liczba cianek danej kostki.
   */
   
   public Die(int numSides)
   {
      // Sprawdzanie, czy liczba cianek jest poprawna.
     if (numSides < MIN_SIDES)
     {
       throw new IllegalArgumentException(
         "Minimalna liczba cianek to " +
         MIN_SIDES + ".");
     }

     // Zapisywanie liczby cianek i wykonywanie rzutu.
      sides = numSides;
      roll();
   }
   
   /**
      Metoda roll symuluje rzut
      kostk.
   */
   
   public void roll()
   {
      // Tworzenie obiektu typu Random.
      Random rand = new Random();

      // Pobieranie losowej wartoci rzutu.
      value = rand.nextInt(sides) + 1;
   }
   
   /**
      Metoda getSides.
      @return Liczba cianek danej kostki.
   */
   
   public int getSides()
   {
      return sides;
   }
   
   /**
      Metoda getValue.
      @return Liczba wyrzuconych oczek.
   */
   
   public int getValue()
   {
      return value;
   }
}