import java.util.Scanner; 

/**
   Ten program ilustruje przekazywanie tablicy
   jako argumentu metody.
*/

public class PassArray
{
   public static void main(String[] args)
   {
      final int ARRAY_SIZE = 4;  // Wielko tablicy.

      // Tworzenie tablicy.
      int[] numbers = new int[ARRAY_SIZE];

      // Przekazywanie tablicy do metody getValues.
      getValues(numbers);

      System.out.println("Oto podane " +
                         "liczby:");

      // Przekazywanie tablicy do metody showArray.
      showArray(numbers);
   }

   /**
      Metoda getValues przyjmuje jako argument 
      referencj do tablicy. Uytkownik ma
      poda warto kadego elementu tej tablicy.
      @param array Referencja do tablicy.
   */

   private static void getValues(int[] array)
   {
      // Tworzenie obiektu typu Scanner do pobierania danych z klawiatury.
      Scanner keyboard = new Scanner(System.in);

      System.out.println("Podaj seri " +
                         array.length + " liczb.");

      // Wczytywanie wartoci do tablicy.
      for (int index = 0; index < array.length; index++)
      {
         System.out.print("Podaj liczb numer " +
                          (index + 1) + ": ");
         array[index] = keyboard.nextInt();
      }
   }

   /**
      Metoda showArray przyjmuje argument w postaci
      tablicy i wywietla jej zawarto.
      @param array Referencja do tablicy.
   */

   public static void showArray(int[] array)
   {
      // Wywietlanie elementw tablicy.
      for (int index = 0; index < array.length; index++)
         System.out.print(array[index] + " ");
   }
}