/**
   Wyjtki typu NegativeStartingBalance s zgaszane
   przez klas BankAccount w sytuacji, gdy do konstruktora
   przekazany zostanie ujemny pocztkowy stan konta.
*/

public class NegativeStartingBalance
                   extends Exception
{
   /**
      W tym konstruktorze uywany jest
      niestandardowy komunikat o bdzie.
   */

   public NegativeStartingBalance()
   {
      super("Bd: ujemny pocztkowy stan konta");
   }

   /**
      Ten konstruktor informuje w komunikacie o bdzie
      o nieprawidowym pocztkowym stanie konta.
      @param Bdny pocztkowy stan konta.
   */

   public NegativeStartingBalance(double amount)
   {
      super("Bd: ujemny pocztkowy stan konta: " +
            amount);
   }
}
