import java.sql.*;   // Potrzebne do tego, by mc uywa klas JDBC.

/**
 * Ten program ilustruje, jak skierowa do bazy danych SQL-ow 
 * instrukcj SELECT przy uyciu technologii JDBC.
 */
public class ShowCoffees
{
   public static void main(String[] args)
   {
      // Tworzenie staej z adresem URL.
      // UWAGA: Ta warto jest specyficzna dla systemw Java DB i Apache Derby.
      final String DB_URL = "jdbc:derby:CoffeeDB";
      
      try
      {
         // Nawizywanie poczenia z baz danych.
         Connection conn = DriverManager.getConnection(DB_URL);
         
         // Tworzenie obiektu typu Statement.
         Statement stmt = conn.createStatement();
         
         // Tworzenie acucha znakw z instrukcj SELECT.
         String sqlStatement = 
            "SELECT * FROM Coffee WHERE Price > 10.00";
         
         // Przesyanie instrukcji do systemu DBMS.
         ResultSet result = stmt.executeQuery(sqlStatement);
         
         // Wywietlanie nagwka listy.
         System.out.println("Kawy z cen powyej 10.00 z za 100 g");
         System.out.println("-------------------------------------");
         
         // Wywietlanie zawartoci zbioru wynikw.
         // Zbir wynikw obejmuje trzy kolumny.
         while (result.next())
         {
            System.out.println(result.getString("Description") + 
                               result.getString("ProdNum") + 
                               result.getDouble("Price"));
         }
         
         // Zamykanie poczenia.
         conn.close();
      }
      catch(Exception ex)
      {
         System.out.println("BD: " + ex.getMessage());
      }
   }
}
