import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.control.Label;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.geometry.Pos;
import javafx.geometry.Insets;

public class ListViewDemo1 extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie kontrolki typu ListView z acuchami znakw.
     ListView<String> listView = new ListView<>();
     listView.setPrefSize(120, 100);
     listView.getItems().addAll("Stefan", "Beata", "Wojciech", "Katarzyna");

     // Tworzenie kontrolki typu Label, gdzie wywietlane jest zaznaczone imi.
     Label selectedNameLabel = new Label("Zaznacz imi");

     // Tworzenie przycisku do pobierania zaznaczonego imienia.
     Button getButton = new Button("Pobierz zaznaczone imi");

     // Tworzenie obiektu obsugi zdarze dla przycisku.
      getButton.setOnAction(event ->
      {
         // Pobieranie zaznaczonego imienia.
         String selected = listView.getSelectionModel().getSelectedItem();
         
         // Wywietlanie zaznaczonego imienia w kontrolce typu Label.
         selectedNameLabel.setText(selected);
      });
      
      // Dodawanie kontrolek do kontenera typu VBox.
      VBox vbox = new VBox(10, listView, selectedNameLabel, getButton);
      vbox.setPadding(new Insets(10));
      vbox.setAlignment(Pos.CENTER);
               
      // Tworzenie sceny i wywietlanie jej.
      Scene scene = new Scene(vbox);
      primaryStage.setScene(scene);
      primaryStage.show();
   }
}