import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.layout.HBox;
import javafx.geometry.Insets;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

/**
 *  Ten program ilustruje marginesy i odstpy.
 */

public class HBoxImagesWithPadding extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Tworzenie komponentw typu Image.
      Image moonImage = new Image("file:Moon.jpg");
      Image shipImage = new Image("file:Ship.jpg");
      Image sunsetImage = new Image("file:Sunset.jpg");
      
      // Tworzenie komponentw typu ImageView.
      ImageView moonIView = new ImageView(moonImage);
      ImageView shipIView = new ImageView(shipImage);
      ImageView sunsetIView = new ImageView(sunsetImage);
      
      // Zmiana wielkoci obrazu ksiyca z zachowaniem proporcji.
      moonIView.setFitWidth(200);
      moonIView.setPreserveRatio(true);
      
      // Zmiana wielkoci obrazu statku z zachowaniem proporcji.
      shipIView.setFitWidth(200);
      shipIView.setPreserveRatio(true);

      // Zmiana wielkoci obrazu zachodu soca z zachowaniem proporcji.
      sunsetIView.setFitWidth(200);
      sunsetIView.setPreserveRatio(true);  
      
      // Umieszczanie obiektw typu ImageView w obiekcie typu HBox z odstpami 10 pikseli.
      HBox hbox = new HBox(10, moonIView, shipIView, sunsetIView);
      
      // Dodawanie 30 pikseli marginesu wok kontenera typu HBox.
      hbox.setPadding(new Insets(30));
      
      // Tworzenie obiektu typu Scene z kontenerem typu HBox jako wzem korzenia.
      Scene scene = new Scene(hbox);
      
      // Dodawanie obiektu typu Scene do obiektu typu Stage.
      primaryStage.setScene(scene);
      
      // Ustawianie tytuu ptna.
      primaryStage.setTitle("Obrazy");

      // Wywietlanie okna.
      primaryStage.show();
   }
}