/**
   Ta klasa przechowuje dane na temat studenta informatyki.
*/

public class CompSciStudent extends Student
{
   // Liczba godzin wymagana do zaliczenia.
   private final int MATH_HOURS = 20;   // Godziny zaj z matematyki.
   private final int CS_HOURS = 40;     // Godziny zaj z informatyki.
   private final int GEN_ED_HOURS = 60; // Godziny zaj z edukacji oglnej.

   // Zaliczone godziny.
   private int mathHours;  // Zaliczone godziny zaj z matematyki.
   private int csHours;    // Zaliczone godziny zaj z informatyki.
   private int genEdHours; // Zaliczone godziny zaj z edukacji oglnej.

   /**
     Konstruktor ustawia imi i nazwisko, 
     identyfikator i rok przyjcia studenta.
     @param n Imi i nazwisko studenta.
     @param id Identyfikator studenta.
     @param year Rok przyjcia studenta.
   */

   public CompSciStudent(String n, String id, int year)
   {
      super(n, id, year);
   }

   /**
      Metoda setMathHours ustawia 
      liczb zaliczonych zaj z matematyki.
      @param math Liczba zaliczonych godzin z matematyki.
   */

   public void setMathHours(int math)
   {
      mathHours = math;
   }

   /**
      Metoda setCsHours ustawia liczb
      zaliczonych godzin z informatyki.
      @param cs Liczba zaliczonych godzin z informatyki.
   */

   public void setCsHours(int cs)
   {
      csHours = cs;
   }

   /**
      Metoda setGenEdHours ustawia liczb zaliczonych
      godzin zaj z edukacji oglnej.
      @param genEd Liczba zaliczonych godzin zaj z edukacji oglnej.
   */

   public void setGenEdHours(int genEd)
   {
      genEdHours = genEd;
   }

   /**
      Metoda getRemainingHours zwraca liczb
      godzin, jakie student jeszcze musi zaliczy.
      @return Liczba godzin, jakie student musi jeszcze zaliczy.
   */

   @Override
   public int getRemainingHours()
   {
      int reqHours,        // czna liczba godzin potrzebnych do zaliczenia.
          remainingHours; // Liczba godzin pozostaych do zaliczenia.

      // Obliczanie cznej liczby godzin wymaganych do zaliczenia.
      reqHours = MATH_HOURS + CS_HOURS + GEN_ED_HOURS;

      // Obliczanie liczby godzin pozostaych do zaliczenia.
      remainingHours = reqHours - (mathHours + csHours
                         + genEdHours);
                         
      return remainingHours;
   }

   /**
      Metoda toString zwraca acuch znakw 
      zawierajcy dane na temat studenta.
      @return Referencja do obiektu typu String.
   */
   
   @Override
   public String toString()
   {
      String str;

      str = super.toString() +
         "\nKierunek: Informatyka" +
         "\nZaliczone godziny matematyki: " + mathHours +
         "\nZaliczone godziny informatyki: " + csHours +
         "\nZaliczone godziny edukacji oglnej: " + genEdHours;

      return str;
   }
}