/**
   Klasa BankAccount symuluje funkcjonowanie konta bankowego.
*/

public class BankAccount
{
   private double balance;      // Stan konta.

   /**
     Ten konstruktor ustawia pocztkowy stan konta
     na warto 0.0.
   */

   public BankAccount()
   {
      balance = 0.0;
   }
   
   /**
      Ten konstruktor ustawia pocztkowy stan konta
     na warto przekazan jako argument.
     @param startBalance Pocztkowy stan konta.
   */

   public BankAccount(double startBalance)
   {
      balance = startBalance;
   }

   /**
      Ten konstruktor ustawia pocztkowy stan konta
     na podstawie wartoci podanej w argumencie typu String.
     @param str Pocztkowy stan konta jako warto typu String.
   */

   public BankAccount(String str)
   {
      balance = Double.parseDouble(str);
   }

   /**
      Metoda deposit pozwala zdeponowa
     rodki na koncie.
     @param amount Warto dodawana do 
                 pola balance.
   */

   public void deposit(double amount)
   {
      balance += amount;
   }

   /**
      Metoda deposit pozwala zdeponowa
     rodki na koncie.
     @param str Kwota dodawana do pola balance,
             podawana jako warto typu String.
   */

   public void deposit(String str)
   {
      balance += Double.parseDouble(str);
   }

   /**
      Metoda withdraw pozwala wycofa 
     rodki z konta.
     @param amount Kwota odejmowana
                 od pola balance.
   */

   public void withdraw(double amount)
   {
      balance -= amount;
   }

   /**
      Metoda withdraw pozwala wycofa 
     rodki z konta.
     @param str Kwota odejmowana od pola balance,
             podawana jako warto typu String.
   */

   public void withdraw(String str)
   {
      balance -= Double.parseDouble(str);
   }

   /**
      Metoda setBalance ustawia stan konta.
     @param b Warto zapisywana w polu balance.
   */

   public void setBalance(double b)
   {
      balance = b;
   }

   /**
      Metoda setBalance ustawia stan konta.
    @param str Kwota zapisywana w polu balance,
             podawana jako warto typu String.
   */

   public void setBalance(String str)
   {
      balance = Double.parseDouble(str);
   }
   
   /**
      Metoda getBalance zwraca
    stan konta.
    @return Warto w polu balance.
   */

   public double getBalance()
   {
      return balance;
   }
}
