import javax.swing.JOptionPane;

/**
   Ten program pobiera wartoci sprzeday z tygodnia.
   Uywana jest tu klasa SalesData do wywietlania sumy,
   redniej, najwyszej i najniszej wartoci sprzeday.
*/

public class Sales
{
   public static void main(String[] args)
   {
      final int ONE_WEEK = 7; // Liczba elementw.

      // Tworzenie tablicy do przechowywania wartoci sprzeday z dni tygodnia.
      double[] sales = new double[ONE_WEEK];

      // Pobieranie wartoci sprzeday z tygodnia.
      getValues(sales);

      // Tworzenie obiektu typu SalesData zainicjowanego 
      // danymi sprzedaowymi z okresu tygodnia.
      SalesData week = new SalesData(sales);

      // Wywietlanie sumy, redniej, najwyszej i najniszej
      // wartoci sprzeday z okresu tygodnia.
      JOptionPane.showMessageDialog(null,
        String.format("Sprzeda w sumie wyniosa %,.2f zotych.\n" +
                      "rednia sprzeda wyniosa %,.2f zotych.\n" +
                      "Najwysza warto sprzeday wyniosa %,.2f zotych.\n" +
                      "Najnisza  warto sprzeday wyniosa %,.2f zotych.",
                       week.getTotal(),
                       week.getAverage(),
                       week.getHighest(),
                       week.getLowest()));

      System.exit(0);
   }

   /**
      Metoda getValues wywietla prob o podanie wartoci
      sprzeday przypisywanych kademu elementowi tablicy.
      @param array Tablica, w ktrej zapisywane s wartoci.
   */

   private static void getValues(double[] array)
   {
      String input;  // Przechowywanie danych wejciowych od uytkownika.

      // Pobieranie wartoci sprzeday z kadego dnia tygodnia.
      for (int i = 0; i < array.length; i++)
      {
         input = JOptionPane.showInputDialog(
                  "Podaj warto sprzeday z dnia numer " + (i + 1) + ": ");
         array[i] = Double.parseDouble(input);
      }
   }
}
