import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.collections.ObservableList;
import javafx.scene.control.Label;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.geometry.Pos;
import javafx.geometry.Insets;

public class ListViewDemo4 extends Application
{
   public static void main(String[] args)
   {
      // Uruchamianie aplikacji.
      launch(args);
   }
   
   @Override
   public void start(Stage primaryStage)
   {
      // Stae okrelajce wielko kontrolek typu ListView.
      final double WIDTH = 120, HEIGHT = 140;

      // Tworzenie kontrolki typu ListView z nazwami miesicy.
      ListView<String> listView1 = new ListView<>();
      listView1.setPrefSize(WIDTH, HEIGHT);
      listView1.getSelectionModel().setSelectionMode(
           SelectionMode.MULTIPLE);
      listView1.getItems().addAll(
           "Stycze", "Luty", "Marzec", "Kwiecie", "Maj",
           "Czerwiec", "Lipiec", "Sierpie", "Wrzesie", "Padziernik",
           "Listopad", "Grudzie");

      // Tworzenie pustej kontrolki typu ListView do wywietlania zaznaczonych elementw.
      ListView<String> listView2 = new ListView<>();
      listView2.setPrefSize(WIDTH, HEIGHT);
      
      // Tworzenie przycisku do pobierania zaznaczonych elementw.
      Button getButton = new Button("Pobierz zaznaczone elementy");

      // Rejestrowanie obiektu obsugi zdarze dla przycisku.
      getButton.setOnAction(event ->
      {
         // Tworzenie obiektu typu ObservableList z zaznaczonymi elementami.
         ObservableList<String> selections =
            listView1.getSelectionModel().getSelectedItems();
         
         // Dodawanie zaznaczonych elementw do drugiej kontrolki typu ListView.
         listView2.getItems().setAll(selections);
      });
      
      // Dodawanie kontrolek do kontenera typu VBox.
      VBox vbox = new VBox(10, listView1, 
                           listView2, getButton);
      vbox.setPadding(new Insets(10));
      vbox.setAlignment(Pos.CENTER);
               
      // Tworzenie sceny i wywietlanie jej.
      Scene scene = new Scene(vbox);
      primaryStage.setScene(scene);
      primaryStage.show();
   }
}