/**
   Student to klasa abstrakcyjna przechowujca
   oglne dane na temat studenta. Klasy reprezentujce
   studentw konkretnych kierunkw dziedzicz po
   tej klasie.
*/

public abstract class Student
{
   private String name;       // Nazwisko studenta.
   private String idNumber;  // Identyfikator studenta.
   private int yearAdmitted; // Rok przyjcia na studia.

   /**
     Konstruktor ustawia nazwisko,
     identyfikator i rok przyjcia studenta.
     @param n Nazwisko studenta.
     @param id Identyfikator studenta.
     @param year Rok przyjcia studenta.
   */

   public Student(String n, String id, int year)
   {
      name = n;
      idNumber = id;
      yearAdmitted = year;
   }

   /**
      Metoda toString zwraca obiekt typu String 
     zawierajcy dane na temat studenta.
     @return Referencja do obiektu typu String.
   */

   public String toString()
   {
      String str;

      str = "Nazwisko: " + name
           + "\nIdentyfikator: " + idNumber
           + "\nRok przyjcia: " + yearAdmitted;
     return str;
   }

   /**
     Metoda getRemainingHours to metoda abstrakcyjna.
     Trzeba j przesoni w klasach pochodnych.
     @return Liczba godzin zaj, jakie student musi jeszcze zaliczy.
   */

   public abstract int getRemainingHours();
}